% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_4Darray.R
\name{get_4Darray}
\alias{get_4Darray}
\title{Assembles a 4D-array}
\usage{
get_4Darray(listPath, i, lon, lat, days, years)
}
\arguments{
\item{listPath}{list, containing lists with names of files to be assembled as a 4D array.}

\item{i}{numeric indicating \eqn{i}-th entry of \code{listPath} to be processed.}

\item{lon}{character vector whose entries indicate longitude coordinates.}

\item{lat}{character vector whose entries indicate latitude coordinates.}

\item{days}{numeric vector indicating what days are being considered. Length of this
object must be equal to length of \code{listPath}.}

\item{years}{integer vector indicating what years are being considered. Length of this
object must be equal to length of \code{listPath}.}
}
\value{
An array of 4 dimensions: longitude, latitude, days and years
}
\description{
This function returns a 4D-array which is an auxiliary
object when invoking \code{\link[igapfill]{applyGapfill}}.
}
\details{
Each entry of \code{listPath} must contain files associated with images
registered during the same year. \code{lon} and \code{lat} can be obtained with the functions \code{\link[igapfill]{get_LON}}
and \code{\link[igapfill]{get_LAT}}, respectively. \code{days} must be provided by the user, otherwise
it will be set to \code{1:length(years)}.
}
\note{
This function may be useful when employing \code{\link[gapfill]{Gapfill}}
independently of the current package.
}
\seealso{
\code{\link[igapfill]{create_dirs}}, \code{\link[igapfill]{get_3Darray}}
}
