% Generated by roxygen2 (4.0.2): do not edit by hand
\name{uniquenessPrior}
\alias{uniquenessPrior}
\title{Uniqueness prior to assist in item factor analysis}
\usage{
uniquenessPrior(model, numFactors, strength = 0.1, name = "uniquenessPrior")
}
\arguments{
\item{model}{an mxModel}

\item{numFactors}{the number of factors.
All items are assumed to have the same number of factors.}

\item{strength}{the strength of the prior}

\item{name}{the name of the mxModel that is returned}
}
\value{
an mxModel that evaluates to the prior density in deviance units
}
\description{
To prevent Heywood cases, Bock, Gibbons, & Muraki (1988)
suggested a beta prior on the uniqueness (Equations 43-46).
The analytic gradient and Hessian are
included for quick optimization using Newton-Raphson.
}
\details{
To reproduce these derivatives in maxima for the case
of 2 slopes (\code{c} and \code{d}), use the following code:

\code{f(c,d) := -p*log(1-(c^2 / (c^2+d^2+1) + (d^2 / (c^2+d^2+1))));}

\code{diff(f(c,d), d),radcan;}

\code{diff(diff(f(c,d), d),d),radcan;}

The general pattern is given in Bock, Gibbons, & Muraki.
}
\examples{
numItems <- 6
spec <- list()
spec[1:numItems] <- rpf.drm(factors=2)
names(spec) <- paste0("i", 1:numItems)
item <- mxMatrix(name="item", free=TRUE,
                 values=mxSimplify2Array(lapply(spec, rpf.rparam)))
item$labels[1:2,] <- paste0('p',1:(numItems * 2))
data <- rpf.sample(500, spec, item$values)
m1 <- mxModel(model="m1", item,
              mxData(observed=data, type="raw"),
              mxExpectationBA81(spec),
              mxFitFunctionML())
up <- uniquenessPrior(m1, 2)
container <- mxModel("container", m1, up,
                     mxFitFunctionMultigroup(c("m1", "uniquenessPrior")),
                     mxComputeSequence(list(
                       mxComputeOnce('fitfunction', c('fit','gradient')),
                       mxComputeReportDeriv())))
container <- mxRun(container)
container$output$fit
container$output$gradient
}
\references{
Bock, R. D., Gibbons, R., & Muraki, E. (1988). Full-information item factor analysis.
\emph{Applied Psychological Measurement, 12}(3), 261-280.
}

