#' Period Table of the Elements (Wikipedia)
#'
#' A table containing the periodic table of the elements from Wikipedia.
#'
#'
#'
#' @format A data.table data frame with 118 rows and 16 variables:
#' \describe{
#' \item{Name}{Name of the element}
#' \item{Atomic Number (Z)}{Atomic number of the element}
#' \item{Formula}{Chemical formula of the element}
#' \item{Standard Atomic weight (Da)}{Element atomic mass in Dalton unit}
#' \item{Origin of name}{Origin of the element name}
#' \item{Group}{Group number of the element}
#' \item{Group Block}{Group block name of the element}
#' \item{Period}{Period number of the element}
#' \item{Density (g/cm^3)}{Element density in grams / cubic centimeters}
#' \item{Melting Point (K)}{Element melting point in Kelvin}
#' \item{Boiling Point (K)}{Element boiling point in Kelvin}
#' \item{Specific Heat Capacity (J/g K)}{Specific heat capacity of the element in Joules / grams Kelvin}
#' \item{Electronegativity}{Element electronegativity}
#' \item{Abundance in Earth's crust (mg/kg)}{Amount present in the Earth's crust}
#' \item{Origin}{Origin of the element}
#' \item{Standard State at Room Temperature}{Standard state of the element at room temperature}
#' }
#'
#'
#' @source
#' Wikimedia Foundation, Inc. Wikipedia, 18 September 2023, "List of chemical elements", \url{https://en.wikipedia.org/wiki/List_of_chemical_elements}.
#'
#'
#'
#'
#'
#'
"elements_wiki"
#> [1] "elements_wiki"
