% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc.R
\encoding{UTF-8}
\name{nc4}
\alias{nc4}
\title{Krishnamurthy and Christensen method for composite Manning's n}
\usage{
nc4(P, n, y)
}
\arguments{
\item{P}{numeric vector that contains "wetted perimeters of any section i"}

\item{n}{numeric vector that contains "Manning's n of any section i"}

\item{y}{numeric vector that contains "flow depth in the ith section"}
}
\value{
numeric vector that contains nc4 as Manning's composite n.
}
\description{
This function computes the composite Manning's n using the Krishnamurthy
and Christensen method.
}
\details{
"A composite value of Manning's n for a single channel; that is, for the
main channel only of a compound channel or a canal with laterally varying
roughness."

The equation to find Manning's composite n using the Krishnamurthy and
Christensen method is

\deqn{\ln n_c = \frac{\sum \limits_{i=1}^N P_iy_i^\frac{3}{2} \ln n_i}{\sum \limits_{i=1}^N P_i y_i^\frac{3}{2}}}

\describe{
\item{\emph{\eqn{n_c}}}{Manning's composite n}
\item{\emph{\eqn{P_i}}}{"wetted perimeters of any section i"}
\item{\emph{\eqn{y_i}}}{"flow depth in the ith section"}
\item{\emph{\eqn{n_i}}}{"Manning's n of any section i"}
\item{\emph{N}}{"total number of sections into which the wetted
       perimeters and hydraulic radius are divided"}
}
}
\examples{

library("iemisc")

nc4(n = c(0.0024, 0.035), P = c(23.65, 36.08), y = c(10.23, 7.38))


}
\references{
\enumerate{
   \item Terry W. Sturm, \emph{Open Channel Hydraulics}, 2nd Edition, New York City, New York: The McGraw-Hill Companies, Inc., 2010, page 118-119.
}
}
\seealso{
\code{\link{n}} for Manning's n for natural channels, \code{\link{nc1}} for
  Horton method for composite Manning's n, \code{\link{nc2}} for Einstein and Banks
  method for composite Manning's n, and \code{\link{nc3}} for Lotter method for
  composite Manning's n.
}
\author{
Irucka Embry
}
