% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgivenFcont.R
\encoding{UTF-8}
\name{FgivenAcont}
\alias{FgivenAcont}
\title{Future value given Annual value [continuous] (Engineering Economics)}
\usage{
FgivenAcont(A, n, r)
}
\arguments{
\item{A}{numeric vector that contains the annual value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{r}{numeric vector that contains the continuously compounded nominal
annual interest rate(s) as a percent}
}
\value{
FgivenAcont numeric vector that contains the future value(s)
   rounded to 2 decimal places
}
\description{
Compute F given A with interest compounded continuously
}
\details{
F is expressed as

	\deqn{F = A\left[\frac{e^{rn} - 1}{e^{r} - 1}\right]}

\describe{
\item{\emph{F}}{the "future equivalent"}
\item{\emph{A}}{the "annual equivalent amount (occurs at the end of
    each year)"}
\item{\emph{r}}{the "nominal annual interest rate, compounded
    continuously"}
\item{\emph{n}}{the "number of periods (years)"}
}
}
\examples{
library("iemisc")
FgivenAcont(2100, 13, 7) # the interest rate is 7\%




}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 169.
}
