% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-conversion.R
\name{CarToPol}
\alias{CarToPol}
\alias{CarToPol,matrix-method}
\alias{CarToPol,numeric-method}
\alias{CarToPol,data.frame-method}
\title{Conversion of 3d Cartesian coordinates to polar coordinates}
\usage{
CarToPol(x, ...)

\S4method{CarToPol}{matrix}(x, norad = FALSE, origin = c(0, 0, 0))

\S4method{CarToPol}{numeric}(x, norad = FALSE, origin = c(0, 0, 0))

\S4method{CarToPol}{data.frame}(x, norad = FALSE, origin = c(0, 0, 0))
}
\arguments{
\item{x}{(\code{matrix}, \code{data.frame}, \code{numeric}) A 3 column data matrix with XYZ coordinates in Cartesian space.}

\item{...}{Arguments passed to class-specific methods.}

\item{norad}{(\code{logical}). Toggles whether the rho coordinate (distance from origin) should be omitted from the output.}

\item{origin}{(\code{numeric}) Vector with length \code{3}, the XYZ coordinates of the sphere center.}
}
\value{
A 3-column or 2-column \code{numeric}, \code{matrix} or \code{data.frame} with longitude, latitude and, if set accordingly, radius data.
}
\description{
The function uses basic trigonometric relationships to transform XYZ coordinates to polar coordinates
}
\examples{
# some random points
xyz <- rbind(
  c(6371, 0,0),
  c(0, 6371,0),
  c(1000,1000,1000)
)

# conversions
  CarToPol(xyz)
}
