% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-lookup.R
\name{pos}
\alias{pos}
\title{Position of face centers and vertices on a grid}
\usage{
pos(gridObj, names, output = "polar")
}
\arguments{
\item{gridObj}{a (\code{\link{hexagrid}} or \code{\link{trigrid}}) Icosahedral grid object.}

\item{names}{(\code{character}) Vector of the names that are to be looked up.}

\item{output}{(\code{character}) The coordinate system in which the names are to be shown: use \code{"polar"} for longitude-latitude and \code{"cartesian"} for XYZ output.}
}
\value{
A \code{numeric} matrix.
}
\description{
This function will retrieve the position of a vertex or a face on a \code{\link{hexagrid}} or \code{\link{trigrid}} object.
}
\details{
Vertex and face names can be mixed in a single \code{names} argument.
}
\examples{
g <- trigrid(c(4,4))
pos(g, c("F2", "P6", "dummyname"))


}
