% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_redundant_observations.R
\name{remove_redundant_observations}
\alias{remove_redundant_observations}
\title{Remove redundant observations from supplied data frame}
\usage{
remove_redundant_observations(gd, tmat)
}
\arguments{
\item{gd}{A \code{data.frame} with the following named columns
\describe{
  \item{\code{id}:}{Subject idenitifier;}
  \item{\code{state}:}{State at which the subject is observed at \code{time};}
  \item{\code{time}:}{Time at which the subject is observed;}
} The true transition time between states is then interval censored between the times.}

\item{tmat}{A transition matrix as created by \code{transMat}}
}
\value{
A \code{data.frame} containing the information contained in  the 
input \code{data.frame} \code{gd},
but without redundant observations. Depending on whether \code{tmat} was 
specified the function may remove more observations.
}
\description{
Remove redundant observed states from a supplied data frame. 
Observations are redundant either when we observe an absorbing state multiple 
times (as we cannot leave an absorbing state), or 
when a transient state is observed multiple times between transitions (as 
we cannot have loops, therefore no extra information is provided when 
we observe a transient state multiple times).
}
\examples{
#We simulate some data
#Function to generate evaluation times: at 0 and uniform inter-observation
eval_times <- function(n_obs, stop_time){
 cumsum( c( 0,  runif( n_obs-1, 0, 2*(stop_time-4)/(n_obs-1) ) ) )
}

#Simulate illness-death model data with Weibull transitions
sim_dat <- sim_id_weib(n = 20, n_obs = 6, stop_time = 15, eval_times = eval_times,
                       start_state = "stable", shape = c(0.5, 0.5, 2), 
                       scale = c(5, 10, 10/gamma(1.5)))
visualise_msm(sim_dat)
require(mstate)
sim_dat_clean <- remove_redundant_observations(sim_dat, trans.illdeath())
visualise_msm(sim_dat_clean)

}
