# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @rdname icd9Comorbid
#' @export
icd9ComorbidShort <- function(icd9df, icd9Mapping, visitId = "visitId", icd9Field = "icd9") {
    .Call('icd9_icd9ComorbidShort', PACKAGE = 'icd9', icd9df, icd9Mapping, visitId, icd9Field)
}

#' @rdname convert
#' @name convert
#' @export
icd9MajMinToCode <- function(major, minor, isShort) {
    .Call('icd9_icd9MajMinToCode', PACKAGE = 'icd9', major, minor, isShort)
}

#' @rdname convert
#' @export
icd9MajMinToShort <- function(major, minor) {
    .Call('icd9_icd9MajMinToShort', PACKAGE = 'icd9', major, minor)
}

#' @rdname convert
#' @export
icd9MajMinToDecimal <- function(major, minor) {
    .Call('icd9_icd9MajMinToDecimal', PACKAGE = 'icd9', major, minor)
}

#' @rdname convert
#' @export
icd9PartsToShort <- function(parts) {
    .Call('icd9_icd9PartsToShort', PACKAGE = 'icd9', parts)
}

#' @rdname convert
#' @export
icd9PartsToDecimal <- function(parts) {
    .Call('icd9_icd9PartsToDecimal', PACKAGE = 'icd9', parts)
}

#' @rdname convert
#' @export
icd9MajMinToParts <- function(major, minor) {
    .Call('icd9_icd9MajMinToParts', PACKAGE = 'icd9', major, minor)
}

icd9MajMinToParts_list <- function(major, minor) {
    .Call('icd9_icd9MajMinToParts_list', PACKAGE = 'icd9', major, minor)
}

#' @rdname convert
#' @export
icd9ShortToParts <- function(icd9Short, minorEmpty = "") {
    .Call('icd9_icd9ShortToParts', PACKAGE = 'icd9', icd9Short, minorEmpty)
}

#' @rdname convert
#' @export
icd9DecimalToParts <- function(icd9Decimal, minorEmpty = "") {
    .Call('icd9_icd9DecimalToParts', PACKAGE = 'icd9', icd9Decimal, minorEmpty)
}

#' @rdname convert
#' @export
icd9ShortToDecimal <- function(icd9Short) {
    .Call('icd9_icd9ShortToDecimal', PACKAGE = 'icd9', icd9Short)
}

#' @rdname convert
#' @export
icd9DecimalToShort <- function(icd9Decimal) {
    .Call('icd9_icd9DecimalToShort', PACKAGE = 'icd9', icd9Decimal)
}

#' @rdname convert
#' @export
icd9GetMajor <- function(icd9, isShort) {
    .Call('icd9_icd9GetMajor', PACKAGE = 'icd9', icd9, isShort)
}

icd9IsASingleV <- function(s) {
    .Call('icd9_icd9IsASingleV', PACKAGE = 'icd9', s)
}

icd9IsASingleE <- function(s) {
    .Call('icd9_icd9IsASingleE', PACKAGE = 'icd9', s)
}

icd9IsASingleVE <- function(s) {
    .Call('icd9_icd9IsASingleVE', PACKAGE = 'icd9', s)
}

#' @name icd9Is
#' @title are the given codes numeric, V or E type?
#' @description Quickly find V or E codes, without any validation.
#' @template icd9-any
#' @export
icd9IsV <- function(icd9) {
    .Call('icd9_icd9IsV', PACKAGE = 'icd9', icd9)
}

#' @rdname icd9Is
#' @export
icd9IsE <- function(icd9) {
    .Call('icd9_icd9IsE', PACKAGE = 'icd9', icd9)
}

#' @rdname icd9Is
#' @export
icd9IsVE <- function(icd9) {
    .Call('icd9_icd9IsVE', PACKAGE = 'icd9', icd9)
}

#' @rdname icd9Is
#' @export
icd9IsN <- function(icd9) {
    .Call('icd9_icd9IsN', PACKAGE = 'icd9', icd9)
}

icd9AddLeadingZeroesMajorSingle <- function(major) {
    .Call('icd9_icd9AddLeadingZeroesMajorSingle', PACKAGE = 'icd9', major)
}

#' @title Add leading zeroes to incomplete ICD codes
#' @description Non-decimal ICD-9 codes with length<5 are often ambiguous. E.g.
#'   100 could be 1.00 10.0 or 100 if coded incorrectly. We must assume 100 is
#'   really 100
#' @template icd9-any
#' @template icd9-short
#' @template icd9-decimal
#' @template major
#' @return character vector of ICD codes (or major part thereof)
#' @keywords internal manip
icd9AddLeadingZeroes <- function(icd9, isShort) {
    .Call('icd9_icd9AddLeadingZeroes', PACKAGE = 'icd9', icd9, isShort)
}

#' @rdname icd9AddLeadingZeroes
icd9AddLeadingZeroesShort <- function(icd9Short) {
    .Call('icd9_icd9AddLeadingZeroesShort', PACKAGE = 'icd9', icd9Short)
}

#' @rdname icd9AddLeadingZeroes
icd9AddLeadingZeroesDecimal <- function(icd9Decimal) {
    .Call('icd9_icd9AddLeadingZeroesDecimal', PACKAGE = 'icd9', icd9Decimal)
}

#' @rdname icd9AddLeadingZeroes
icd9AddLeadingZeroesMajor <- function(major) {
    .Call('icd9_icd9AddLeadingZeroesMajor', PACKAGE = 'icd9', major)
}

#' @title expand decimal part of ICD-9 code to cover all possible sub-codes
#' @description Accepts a single number or character input starting point for
#'   generation of all possible decimal parts of ICD9 code. e.g. giving an empty
#'   input will fill out 111 combinations, e..g .1 .11 .12 .... .2 ....
#' @template minor
#' @param isE single logical, which if TRUE, treats the minor as part of an E
#'   code (which is one character), as opposed to a V or numeric-only code,
#'   which is two character. Default is \code{FALSE}.
#' @examples
#'   # return all possible decimal parts of ICD9 codes (111 in total)
#'   length(icd9:::icd9ExpandMinor("", isE = FALSE))
#'   icd9:::icd9ExpandMinor("1") # "1"  "10" "11" "12" "13" "14" "15" "16" "17" "18" "19"
#' @return NA for invalid minor, otherwise a vector of all possible (perhaps
#'   non-existent) sub-divisions.
#' @family ICD-9 ranges
#' @keywords internal manip
icd9ExpandMinor <- function(minor, isE = FALSE) {
    .Call('icd9_icd9ExpandMinor', PACKAGE = 'icd9', minor, isE)
}

icd9Children_cpp <- function(icd9, isShort, onlyReal = TRUE) {
    .Call('icd9_icd9Children_cpp', PACKAGE = 'icd9', icd9, isShort, onlyReal)
}

#' @rdname icd9Children
#' @name icd9Children
#' @export
icd9ChildrenShort <- function(icd9Short, onlyReal = TRUE) {
    .Call('icd9_icd9ChildrenShort', PACKAGE = 'icd9', icd9Short, onlyReal)
}

#' @rdname icd9Children
#' @export
icd9ChildrenDecimal <- function(icd9Decimal, onlyReal = TRUE) {
    .Call('icd9_icd9ChildrenDecimal', PACKAGE = 'icd9', icd9Decimal, onlyReal)
}

#' @title match ICD9 codes
#' @description Finds children of \code{icd9Reference} and looks for \code{icd9} in the
#'   resulting vector.
#' @templateVar icd9AnyName "icd9,icd9Reference"
#' @template icd9-any
#' @template isShort
#' @param isShortReference logical, see argument \code{isShort}
#' @return logical vector of which icd9 match or are subcategory of
#'   \code{icd9Reference}
#' @keywords internal
icd9InReferenceCode <- function(icd9, icd9Reference, isShort, isShortReference = TRUE) {
    .Call('icd9_icd9InReferenceCode', PACKAGE = 'icd9', icd9, icd9Reference, isShort, isShortReference)
}

icd9IsV_cpp_slower <- function(sv) {
    .Call('icd9_icd9IsV_cpp_slower', PACKAGE = 'icd9', sv)
}

icd9ShortToParts_cpp_slow <- function(icd9Short, minorEmpty = "") {
    .Call('icd9_icd9ShortToParts_cpp_slow', PACKAGE = 'icd9', icd9Short, minorEmpty)
}

icd9MajMinToParts_slower <- function(major, minor) {
    .Call('icd9_icd9MajMinToParts_slower', PACKAGE = 'icd9', major, minor)
}

icd9IsV_cpp_slow <- function(sv) {
    .Call('icd9_icd9IsV_cpp_slow', PACKAGE = 'icd9', sv)
}

icd9IsE_cpp_slow <- function(sv) {
    .Call('icd9_icd9IsE_cpp_slow', PACKAGE = 'icd9', sv)
}

icd9IsVE_cpp_slow <- function(sv) {
    .Call('icd9_icd9IsVE_cpp_slow', PACKAGE = 'icd9', sv)
}

icd9ShortToParts_cpp_test <- function(icd9Short, minorEmpty = "") {
    .Call('icd9_icd9ShortToParts_cpp_test', PACKAGE = 'icd9', icd9Short, minorEmpty)
}

strim_cpp <- function(s) {
    .Call('icd9_strim_cpp', PACKAGE = 'icd9', s)
}

trim_cpp <- function(sv) {
    .Call('icd9_trim_cpp', PACKAGE = 'icd9', sv)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('icd9_RcppExport_registerCCallable', PACKAGE = 'icd9')
})
