% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9IsVE}
\alias{icd9IsVE}
\title{is the given code V or E type?}
\usage{
icd9IsVE(icd9)
}
\arguments{
\item{icd9}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}
}
\description{
quickly find V or E codes, without fully validating V or E
  codes. Use fixed instead of regex for speed. Don't check position of V or
  E: this is not validation, just a quick classification of pre-validated
  codes. TODO: this doesn't look efficient, but can't use fixed with ignore
  case, and regex slower.
}
\examples{
\dontrun{
# regex is a little faster
icd9 <- rep(times = 500, c("1", "not", "V10.0", " E950", ""))
microbenchmark(times = 1000,
  grepl(pattern = "E", icd9, fixed = TRUE) |
  grepl(pattern = "e", icd9, fixed = TRUE) |
  grepl(pattern = "V", icd9, fixed = TRUE) |
  grepl(pattern = "v", icd9, fixed = TRUE))
microbenchmark(times = 1000, grepl(pattern = "[EeVv]", rnd))
}
}
\keyword{internal}

