% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ExpandBaseCodeDecimal}
\alias{icd9ExpandBaseCodeDecimal}
\title{generate all child codes for given decimal ICD9 codes}
\usage{
icd9ExpandBaseCodeDecimal(icd9Decimal, validate = F)
}
\arguments{
\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{validate}{logical whether to validate the input ICD-9 codes for
correctness. There may be additional simple checks, e.g. whether the code
is of the right type, regardless of this argument.}
}
\value{
unsorted vector of ICD9 codes for all subsections of the provided
  code.
}
\description{
take ICD9 codes in decimal form and lists of all possible
  sub-classification codes: e.g. 1.1 returns 1.11, 1.12, 1.13 etc. There are
  no codes like 1.10 which are distinct from 1.1, so this can be purely
  numeric Also, note that expanding "100.0" (100.00 to 100.09) is different
  from expanding "100.00" (no expansion) \code{0.1 == .3/3} is a problem...
  \url{http://cran.r-project.org/doc/FAQ/R-FAQ.html#Why-doesn_0027t-R-think-these-numbers-are-equal_003f}
}
\examples{
#icd9ExpandBaseCodeDecimal("100.1")
#icd9ExpandBaseCodeDecimal("2.34")
}
\keyword{internal}
\keyword{manip}

