% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess.R
\name{icd_guess_version}
\alias{icd_guess_version}
\alias{icd_guess_version.character}
\alias{icd_guess_version.data.frame}
\alias{icd_guess_version.factor}
\alias{icd_guess_version.icd10}
\alias{icd_guess_version.icd9}
\title{Guess version of ICD codes}
\usage{
icd_guess_version(x, short_code, ...)

\method{icd_guess_version}{icd9}(x, short_code, ...)

\method{icd_guess_version}{icd10}(x, short_code, ...)

\method{icd_guess_version}{factor}(x, short_code = NULL, ...)

\method{icd_guess_version}{character}(x, short_code = NULL, n = 10, ...)

\method{icd_guess_version}{data.frame}(x, short_code = NULL,
  icd_name = get_icd_name(x), ...)
}
\arguments{
\item{x}{input data}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{n}{number of elements or rows to sample}

\item{icd_name}{The column in the \code{data.frame} which contains the ICD
codes. This is a character vector of length one. If it is \code{NULL},
\code{icd9} will attempt to guess the column name, looking for
progressively less likely possibilities until it matches a single column.
Failing this, it will take the first column in the data frame. Specifying
the column using this argument avoids the guesswork.}
}
\description{
The guess is indeed a guess and can be wrong. There are some codes which
could be either ICD-9 or ICD-10. The current implementation doesn't check
whether the codes exist in any definitions (ICD-9 CM or WHO, for example),
just whether they are valid.
}
\details{
Currently, ambiguous codes are guessed true or false, with no indication of
uncertainty. Possible solutions are adding an attribute, warning, or
optionally throwing an error.
}
\section{Methods (by class)}{
\itemize{
\item \code{icd9}: Guess version class ICD-9 codes

\item \code{icd10}: Guess version of class ICD-10 codes

\item \code{factor}: Guess version of ICD codes in a factor

\item \code{character}: Guess version of ICD codes in character vector

\item \code{data.frame}: Guess version of ICD codes in a field in a
\code{data.frame}
}}
\keyword{internal}

