% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{HD}
\alias{HD}
\title{Computes extended Hausdorff distance between two trajectories.}
\usage{
HD(pp1, pp2, q = 1)
}
\arguments{
\item{pp1}{Set of spatial points for the first trajectory. It can be a matrix of 2D points, first column x/longitude, second column y/latitude, or a SpatialPoints or SpatialPointsDataFrame object.}

\item{pp2}{Set of spatial points for the second trajectory. It can be a matrix of 2D points, first column x/longitude, second column y/latitude, or a SpatialPoints or SpatialPointsDataFrame object.}

\item{q}{Quantile for the extended Hausdorff distance. Default value q=1 uses the maximum that leads to classical Hausdorff distance.}
}
\value{
A numerical value with the distance.
}
\description{
Computes extended Hausdorff distance between two trajectories.
}
\examples{
# Take two trajectories
library(dplyr)
library(sp)
sample_data<-gull_data \%>\% filter(ID \%in\% c(5107912,5107913), trip \%in\% c("V02","V01"))
tr1<-gull_data \%>\% filter((ID == 5107912) & (trip=="V02"))
tr2<-gull_data \%>\% filter((ID == 5107913) & (trip=="V01"))
pts1 = SpatialPoints(tr1[c("LONG","LAT")], proj4string=CRS("+proj=longlat"))
pts2 = SpatialPoints(tr2[c("LONG","LAT")], proj4string=CRS("+proj=longlat"))
# Hausdorff distance
HD(pts1,pts2,q=1)
# Median Hausdorff distance
HD(pts1,pts2,q=0.5)
}
\references{
{
Magdy, N., Sakr, M., Abdelkader, T., Elbahnasy, K. (2015). Review on trajectory similarity measures. 10.1109/IntelCIS.2015.7397286.

Min, D., Zhilin, L., Xiaoyong, C. (2007) Extended Hausdorff distance for spatial objects in GIS. International Journal of Geographical Information Science, 21:4, 459–475

}
}
