% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grading_tables.R
\name{grading_tables}
\alias{grading_tables}
\alias{create_minreq_table}
\alias{create_grading_table}
\title{Tables Used for Grading the Papers}
\usage{
create_minreq_table(repro, n_tab, n_plot_kinds, n_plots, n_stat)

create_grading_table(p_text, p_tab, p_plot, p_code, p_stat)
}
\arguments{
\item{repro}{logical, is the paper reproducible?}

\item{n_tab}{integer, number of tables}

\item{n_plot_kinds}{integer, number of different kinds of plots}

\item{n_plots}{integer, number of plots}

\item{n_stat}{integer, number of statistical computations}

\item{p_text}{numeric between 0 and 5, points given for the text}

\item{p_tab}{numeric between 0 and 5, points given for the tables}

\item{p_plot}{numeric between 0 and 5, points given for the plots}

\item{p_code}{numeric between 0 and 5, points given for the code}

\item{p_stat}{numeric between 0 and 5, points given for the
statistic computations}
}
\value{
both functions return an object of class \code{kableExtra}.
}
\description{
These functions create two tables that can be used for the grading
of the student's papers.
}
\details{
The tables are created using \code{\link[knitr:kable]{knitr::kable()}} and \code{\link[kableExtra:kableExtra-package]{kableExtra::kableExtra}} is
used for additional styling.

\code{create_minreq_table()} creates a table that checks that the minimal requirements
are satisfied:
\itemize{
\item the paper must be reproducible
\item there must be at least one table and two kinds of plots
\item there must be at least 5 plots and tables
\item there must be at least two statistical computations
}

The table lists for each of those requirement whether it is satisfied or not.

\code{create_grading_table()} creates a table that gives grades in percent for
each of five categories:
\itemize{
\item Text
\item Tables
\item Plots
\item Code
\item Statistical computations
}

In each category, up to five points may be awarded. The last row of the
table gives the percentage over all categories.
}
