% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{desc2}
\alias{desc2}
\title{Depression Screening DESC-II}
\format{A data frame with 799 rows and 14 variables.
\describe{
  \item{code}{id number of the patient}
  \item{group}{a factor with levels  psychiatry, otolaryngology, cardiology, neurology  for the indication group  of the patient.}
  \item{gender}{a factor with levels female, male of the patient.}
  \item{agegroup}{a factor with levels 18-34, 35-49, 50-59, 60-87 for the age  of the patient.}
  \item{DESC_2_1}{feeling not to be needed}
  \item{DESC_2_2}{loss of interest in other people}
  \item{DESC_2_3}{disheartened}
  \item{DESC_2_4}{no pleasure doing things}
  \item{DESC_2_5}{feeling to be no good}
   \item{DESC_2_6}{uninspired}
   \item{DESC_2_7}{pessimistic}
    \item{DESC_2_8}{discouraged}
    \item{DESC_2_9}{withdrawal}
    \item{DESC_2_10}{thinking of taking one's life}
}}
\description{
A dataset containing the responses of 799 patients (indication group psychiatry, otolaryngology, cardiology, neurology)
to the short form DESC-II with 10 items.
There are 5 response categories from 0 = never to 4 = always. A higher score is supposed to mean a higher depression.
}
\examples{
data(desc2)
str(desc2)
}
\references{
Forkmann et al. (2009) Development and validation of the Rasch-based Depression Screening (DESC) using
Rasch analysis and structural equation modelling.
\emph{J Behav Ther Exp Psychiatry}, 40(3): 468-78.
}
\seealso{
\url{http://psychometrikon.de/inhalt/suchen/test.php?id=000000000000000000000000000003}
}
\keyword{datasets}
