% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimalfeatureselection.R
\name{variable_importance.optimal_feature_selection_learner}
\alias{variable_importance.optimal_feature_selection_learner}
\title{Generate a ranking of the variables in an Optimal Feature Selection learner
according to their importance during training. The results are normalized so
that they sum to one.}
\usage{
\method{variable_importance}{optimal_feature_selection_learner}(obj, fit_index = NULL, ...)
}
\arguments{
\item{obj}{The learner to query.}

\item{fit_index}{The index of the cluster to use for prediction, if the
\code{coordinated_sparsity} parameter on the learner is
\code{TRUE}.}

\item{...}{Refer to the Julia documentation for available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.1/OptimalFeatureSelection/reference/#IAI.variable_importance-Tuple\%7BOptimalFeatureSelectionLearner\%7D}{\code{IAI.variable_importance}}
}
\section{IAI Compatibility}{

Requires IAI version 1.1 or higher.
}

\examples{
\dontrun{iai::variable_importance(lnr, ...)}

}
