% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rv.conf.interval}
\alias{rv.conf.interval}
\title{Determining a confidence interval for the (partial) RV coefficient}
\usage{
rv.conf.interval(cors_boot, a, b, set = NULL, conf = 0.95)
}
\arguments{
\item{cors_boot}{The result from run.bootstraps().}

\item{a}{Either an index or a string to identify dataset a.}

\item{b}{Either an index or a string to identify dataset b.}

\item{set}{Optional parameter to define the datasets that need to be partialized for.
If set consists of one dataset, then provide an index or a string to identify set.
If set consists of multiple datasets, then provide a vector of indices or a vector of strings.}

\item{conf}{The size of the confidence interval (default=0.95).}
}
\value{
The confidence interval.
}
\description{
This function uses a bootstrapping procedure to determine a confidence
interval for the RV coefficient RV(a, b) or the partial RV coefficient
RV(a, b | set).
}
\examples{
set.seed(2)
n = 100
p = 100
x1 = matrix(rnorm(n*p), n, p)
x2 = x1 + matrix(rnorm(n*p), n, p)
x3 = x2 + matrix(rnorm(n*p), n, p)
data = list(x1=x1, x2=x2, x3=x3)
config_matrices = compute.config.matrices(data)
cors_boot = run.bootstraps(config_matrices, nboots=1000)
rv.conf.interval(cors_boot, "x1", "x3", "x2")
}
