\docType{package}
\name{iSubpathwayMiner-package}
\alias{iSubpathwayMiner-package}
\alias{iSubpathwayMiner}
\title{The iSubpathwayMiner package}
\description{iSubpathwayMiner is an R platform for graph-based construction, analysis, and visualization of KEGG pathways.}
\section{Introduction}{
The main goal of iSubpathwayMiner is to provide graph-based reconstruction, analysis, and visualization of pathways. (1) The system provides many strategies of converting pathways to graph models. Ten functions related to conversion from pathways to graphs are developed (see the functions \code{\link{getPathway}}, \code{\link{getMetabolicGraph}}, \code{\link{getNonMetabolicGraph}}, \code{\link{filterNode}}, \code{\link{expandNode}}, \code{\link{mergeNode}}, \code{\link{mapNode}}, \code{\link{simplifyGraph}}, \code{\link{getUGraph}}, and \code{\link{getSimpleGraph}}). Furthermore, the combinations of these functions can get many (> 20) combined conversion strategies of pathway graphs (see the function \code{\link{getMetabolicECCOGraph}}). (2) The iSubpathwayMiner can support the annotation and identification of pathways based on compound sets, gene sets, and even the combined sets of genes and compounds. The entire pathway and subpathway identification methods are available for these sets (see the function \code{\link{identifyGraph}} and \code{\link{getKcSubiGraph}}). (3) The system can also support topology-based pathway analysis of these sets. The current available topological properties contain degree, local clustering coefficient, closeness and betweenness (see the function \code{\link{identifyTopo}}). (4) We develop KEGG layout style of pathway graphs in R to simulate the layout of the pathway picture in KEGG website (see the function \code{\link{plotGraph}}). In addition, our system has also provided many types of automatic layout styles. One way to visualize pathway graphs is to firstly visualize with \code{\link{tkplot}}, handtune the placement of the vertices, query the coordinates by the \code{\link{tkplot.getcoords}} function and use them with the function \code{\link{plotGraph}} to visualize the graph to R device. Using the function \code{\link{write.graph}}, pathway graphs can also be exported to the GML format supported by Cytoscape. (5) The iSubpathwayMiner is developed based on the previous system: SubpathwayMiner. It is thus able to provide many good functions provided by SubpathwayMiner. For example, the iSubpathwayMiner can provide the most up-to-date pathway analysis results for users (see the function \code{\link{updateOrgAndIdType}}). It supports can support multiple species (about 139 Eukaryotes, 1141 Bacteria and 93 Archaea) and different gene identifiers (KEGG compound, Entrez Gene IDs, gene official symbol, NCBI-gi IDs, UniProt IDs, PDB IDs, etc.).
}

\author{ Chunquan Li \email{lcqbio@yahoo.com.cn}}
