% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moecalc.R
\name{moecalc}
\alias{moecalc}
\title{Margin of Error Calculation}
\usage{
moecalc(
  x,
  factorname = NULL,
  levelnames = NULL,
  coef.idx = NULL,
  est = NULL,
  ci = NULL,
  base = TRUE,
  basename = "base",
  conf.level = 1.96
)
}
\arguments{
\item{x}{the object for which we compute margins of error}

\item{factorname}{name of factor}

\item{levelnames}{names of factor levels}

\item{coef.idx}{index of coefficient to use}

\item{est}{estimates}

\item{ci}{confidence intervals}

\item{base}{baseline}

\item{basename}{name of baseline}

\item{conf.level}{level of confidence to use}
}
\value{
a \code{moecalc} object
}
\description{
Computes the margin of error for various objects.
}
\details{
If \code{x} is a model, must have factorname or coefficient index (coef.idx)
If input factorname, will compute ErrBars by factorname (for given model)
If input coefficient index, will compute ErrBars simply by index only (even they are not factor)
If \code{x} is \code{ses.moecalc} object, will compute ErrBars simply by given \code{ses.moecalc} object
}
\examples{
fit <- lm(Sepal.Length ~ Species, data = iris)
(mc <- moecalc(fit, "Species"))
summary(mc)
plot(mc)
}
