% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simMRMC.R
\name{roeMetzConfigs}
\alias{roeMetzConfigs}
\title{roeMetzConfigs}
\description{
This is a data frame containing the configuration parameters 
used in Roe1997_Acad-Radiol_v4p298. Each row corresponds to one of the twelve configurations
appearing in Table 1 of that paper in a format that can be the input to \code{sim.gRoeMetz}.
}
\details{
The columns of this data frame are as follows
\itemize{
  \item Experiment labels and size
  \itemize{
    \item modalityID.A: [character] label modality A
    \item modalityID.B: [character] label modality B
    \item nR: [numeric] number of readers
    \item nC.neg: [numeric] number of signal-absent cases
    \item nC.pos: [numeric] number of signal-present cases
  }
  \item There are six fixed effects:
  \itemize{
    \item mu.neg: [numeric] signal-absent (neg, global mean)
    \item mu.pos: [numeric] signal-present (pos, global mean)
    \item mu.Aneg: [numeric] modality A signal-absent (Aneg, modality effect)
    \item mu.Bneg: [numeric] modality B signal-absent (Bneg, modality effect)
    \item mu.Apos: [numeric] modality A signal-present (Apos, modality effect)
    \item mu.Bpos: [numeric] modality B signal-present (Bpos, modality effect)
  }
  \item There are six random effects that are independent of modality
  \itemize{
    \item var_r.neg: [numeric] variance of random reader effect
    \item var_c.neg: [numeric] variance of random case effect
    \item var_rc.neg: [numeric] variance of random reader by case effect
    \item var_r.pos: [numeric] variance of random reader effect
    \item var_c.pos: [numeric] variance of random case effect
    \item var_rc.pos: [numeric] variance of random reader by case effect
  }
  \item There are six random effects that are specific to modality A
    \itemize{
      \item var_r.Aneg: [numeric] variance of random reader effect
      \item var_c.Aneg: [numeric] variance of random case effect
      \item var_rc.Aneg: [numeric] variance of random reader by case effect
      \item var_r.Apos: [numeric] variance of random reader effect
      \item var_c.Apos: [numeric] variance of random case effect
      \item var_rc.Apos: [numeric] variance of randome reader by case effect
  }
  \item There are six random effects that are specific to modality B
    \itemize{
      \item var_r.Bneg: [numeric] variance of random reader effect
      \item var_c.Bneg: [numeric] variance of random case effect
      \item var_rc.Bneg: [numeric] variance of random reader by case effect
      \item var_r.Bpos: [numeric] variance of random reader effect
      \item var_c.Bpos: [numeric] variance of random case effect
      \item var_rc.Bpos: [numeric] variance of randome reader by case effect
  }
}
}
