/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import java.util.Arrays;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class TriangularDist
extends ContinuousDistribution {
    private double a;
    private double b;
    private double m;

    public TriangularDist() {
        this.setParams(0.0, 1.0, 0.5);
    }

    public TriangularDist(double m) {
        this.setParams(0.0, 1.0, m);
    }

    public TriangularDist(double a, double b, double m) {
        this.setParams(a, b, m);
    }

    public double density(double x) {
        return TriangularDist.density(this.a, this.b, this.m, x);
    }

    public double cdf(double x) {
        return TriangularDist.cdf(this.a, this.b, this.m, x);
    }

    public double barF(double x) {
        return TriangularDist.barF(this.a, this.b, this.m, x);
    }

    public double inverseF(double u) {
        return TriangularDist.inverseF(this.a, this.b, this.m, u);
    }

    public double getMean() {
        return TriangularDist.getMean(this.a, this.b, this.m);
    }

    public double getVariance() {
        return TriangularDist.getVariance(this.a, this.b, this.m);
    }

    public double getStandardDeviation() {
        return TriangularDist.getStandardDeviation(this.a, this.b, this.m);
    }

    public static double density(double a, double b, double m, double x) {
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (x < a || x > b) {
            return 0.0;
        }
        if (x <= m && m != a) {
            return 2.0 * (x - a) / ((b - a) * (m - a));
        }
        return 2.0 * (b - x) / ((b - a) * (b - m));
    }

    public static double cdf(double a, double b, double m, double x) {
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (x <= a) {
            return 0.0;
        }
        if (x <= m && m != a) {
            return (x - a) * (x - a) / ((b - a) * (m - a));
        }
        if (x < b) {
            return 1.0 - (b - x) * (b - x) / ((b - a) * (b - m));
        }
        return 1.0;
    }

    public static double barF(double a, double b, double m, double x) {
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (x <= a) {
            return 1.0;
        }
        if (x <= m && m != a) {
            return 1.0 - (x - a) * (x - a) / ((b - a) * (m - a));
        }
        if (x < b) {
            return (b - x) * (b - x) / ((b - a) * (b - m));
        }
        return 0.0;
    }

    public static double inverseF(double a, double b, double m, double u) {
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (u <= 0.0) {
            return a;
        }
        if (u >= 1.0) {
            return b;
        }
        double h = (m - a) / (b - a);
        return u <= h && m != a ? a + Math.sqrt((b - a) * (m - a) * u) : b - Math.sqrt((b - a) * (b - m) * (1.0 - u));
    }

    public static double[] getMLE(double[] x, int n, double a, double b) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] Y = new double[n];
        System.arraycopy(x, 0, Y, 0, n);
        Arrays.sort(Y);
        int rmax = -1;
        double prodmax = -1.0E300;
        double ba = b - a;
        for (int r = 0; r < n; ++r) {
            int i;
            double z = (Y[r] - a) / ba;
            if (z <= (double)r / (double)n || z >= (double)(r + 1) / (double)n) continue;
            double prod = 1.0;
            double d = Y[r] - a;
            for (i = 0; i < r; ++i) {
                prod *= (Y[i] - a) / d;
            }
            d = b - Y[r];
            for (i = r + 1; i < n; ++i) {
                prod *= (b - Y[i]) / d;
            }
            if (!(prod > prodmax)) continue;
            prodmax = prod;
            rmax = r;
        }
        if (rmax < 0) {
            throw new UnsupportedOperationException("   data cannot fit a triangular distribution");
        }
        double[] param = new double[]{Y[rmax]};
        return param;
    }

    public static TriangularDist getInstanceFromMLE(double[] x, int n, double a, double b) {
        double[] param = TriangularDist.getMLE(x, n, a, b);
        return new TriangularDist(a, b, param[0]);
    }

    public static double getMean(double a, double b, double m) {
        if (a == 0.0 && b == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        return (a + b + m) / 3.0;
    }

    public static double getVariance(double a, double b, double m) {
        if (a == 0.0 && b == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        return (a * a + b * b + m * m - a * b - a * m - b * m) / 18.0;
    }

    public static double getStandardDeviation(double a, double b, double m) {
        return Math.sqrt(TriangularDist.getVariance(a, b, m));
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getM() {
        return this.m;
    }

    public void setParams(double a, double b, double m) {
        if (a == 0.0 && b == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        this.a = a;
        this.b = b;
        this.m = m;
        this.supportA = a;
        this.supportB = b;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.b, this.m};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : a = " + this.a + ", b = " + this.b + ", m = " + this.m;
    }
}

