/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.ArithmeticMod;

public class MRG31k3p
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final int M1 = Integer.MAX_VALUE;
    private static final int M2 = 2147462579;
    private static final int MASK12 = 511;
    private static final int MASK13 = 0xFFFFFF;
    private static final int MASK2 = 65535;
    private static final int MULT2 = 21069;
    private static final double NORM = 4.656612873077393E-10;
    private int x11;
    private int x12;
    private int x13;
    private int x21;
    private int x22;
    private int x23;
    private int[] stream;
    private int[] substream;
    private static int[] curr_stream = new int[]{12345, 12345, 12345, 12345, 12345, 12345};
    private static final int[][] A1p0 = new int[][]{{0, 0x400000, 129}, {1, 0, 0}, {0, 1, 0}};
    private static final int[][] A2p0 = new int[][]{{32768, 0, 32769}, {1, 0, 0}, {0, 1, 0}};
    private static final int[][] A1p72 = new int[][]{{1516919229, 758510237, 499121365}, {1884998244, 1516919229, 335398200}, {601897748, 1884998244, 358115744}};
    private static final int[][] A2p72 = new int[][]{{1228857673, 1496414766, 954677935}, {1133297478, 1407477216, 1496414766}, {2002613992, 1639496704, 1407477216}};
    private static final int[][] A1p134 = new int[][]{{1702500920, 1849582496, 1656874625}, {828554832, 1702500920, 1512419905}, {1143731069, 828554832, 102237247}};
    private static final int[][] A2p134 = new int[][]{{796789021, 1464208080, 607337906}, {1241679051, 1431130166, 1464208080}, {1401213391, 1178684362, 1431130166}};

    private static void multMatVect(int[] v, int[][] A, int m1, int[][] B, int m2) {
        int i;
        int[] vv = new int[3];
        for (i = 0; i < 3; ++i) {
            vv[i] = v[i];
        }
        ArithmeticMod.matVecModM(A, vv, vv, m1);
        for (i = 0; i < 3; ++i) {
            v[i] = vv[i];
        }
        for (i = 0; i < 3; ++i) {
            vv[i] = v[i + 3];
        }
        ArithmeticMod.matVecModM(B, vv, vv, m2);
        for (i = 0; i < 3; ++i) {
            v[i + 3] = vv[i];
        }
    }

    public MRG31k3p() {
        this.name = null;
        this.prec53 = false;
        this.anti = false;
        this.stream = new int[6];
        this.substream = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.resetStartStream();
        MRG31k3p.multMatVect(curr_stream, A1p134, Integer.MAX_VALUE, A2p134, 2147462579);
    }

    public MRG31k3p(String name) {
        this();
        this.name = name;
    }

    public static void setPackageSeed(int[] seed) {
        if (seed.length < 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (seed[0] == 0 && seed[1] == 0 && seed[2] == 0) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (seed[5] == 0 && seed[3] == 0 && seed[4] == 0) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        if (seed[0] >= Integer.MAX_VALUE || seed[1] >= Integer.MAX_VALUE || seed[2] >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The first 3 values must be less than 2147483647");
        }
        if (seed[5] >= 2147462579 || seed[3] >= 2147462579 || seed[4] >= 2147462579) {
            throw new IllegalArgumentException("The last 3 values must be less than 2147462579");
        }
        for (int i = 0; i < 6; ++i) {
            MRG31k3p.curr_stream[i] = seed[i];
        }
    }

    public void setSeed(int[] seed) {
        if (seed.length < 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (seed[0] == 0 && seed[1] == 0 && seed[2] == 0) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (seed[3] == 0 && seed[4] == 0 && seed[5] == 0) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        if (seed[0] >= Integer.MAX_VALUE || seed[1] >= Integer.MAX_VALUE || seed[2] >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The first 3 values must be less than 2147483647");
        }
        if (seed[3] >= 2147462579 || seed[4] >= 2147462579 || seed[5] >= 2147462579) {
            throw new IllegalArgumentException("The last 3 values must be less than 2147462579");
        }
        for (int i = 0; i < 6; ++i) {
            this.stream[i] = seed[i];
        }
        this.resetStartStream();
    }

    public void resetStartStream() {
        for (int i = 0; i < 6; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.x11 = this.substream[0];
        this.x12 = this.substream[1];
        this.x13 = this.substream[2];
        this.x21 = this.substream[3];
        this.x22 = this.substream[4];
        this.x23 = this.substream[5];
    }

    public void resetNextSubstream() {
        MRG31k3p.multMatVect(this.substream, A1p72, Integer.MAX_VALUE, A2p72, 2147462579);
        this.resetStartSubstream();
    }

    public int[] getState() {
        return new int[]{this.x11, this.x12, this.x13, this.x21, this.x22, this.x23};
    }

    public MRG31k3p clone() {
        MRG31k3p retour = null;
        retour = (MRG31k3p)super.clone();
        retour.substream = new int[6];
        retour.stream = new int[6];
        for (int i = 0; i < 6; ++i) {
            retour.substream[i] = this.substream[i];
            retour.stream[i] = this.stream[i];
        }
        return retour;
    }

    public String toString() {
        if (this.name == null) {
            return "The state of the MRG31k3p is: " + this.x11 + ", " + this.x12 + ", " + this.x13 + ";  " + this.x21 + ", " + this.x22 + ", " + this.x23;
        }
        return "The state of " + this.name + " is: " + this.x11 + ", " + this.x12 + ", " + this.x13 + ";  " + this.x21 + ", " + this.x22 + ", " + this.x23;
    }

    protected double nextValue() {
        int y2;
        int y1 = ((this.x12 & 0x1FF) << 22) + (this.x12 >>> 9) + ((this.x13 & 0xFFFFFF) << 7) + (this.x13 >>> 24);
        if (y1 < 0 || y1 >= Integer.MAX_VALUE) {
            y1 -= Integer.MAX_VALUE;
        }
        if ((y1 += this.x13) < 0 || y1 >= Integer.MAX_VALUE) {
            y1 -= Integer.MAX_VALUE;
        }
        this.x13 = this.x12;
        this.x12 = this.x11;
        this.x11 = y1;
        y1 = ((this.x21 & 0xFFFF) << 15) + 21069 * (this.x21 >>> 16);
        if (y1 < 0 || y1 >= 2147462579) {
            y1 -= 2147462579;
        }
        if ((y2 = ((this.x23 & 0xFFFF) << 15) + 21069 * (this.x23 >>> 16)) < 0 || y2 >= 2147462579) {
            y2 -= 2147462579;
        }
        if ((y2 += this.x23) < 0 || y2 >= 2147462579) {
            y2 -= 2147462579;
        }
        if ((y2 += y1) < 0 || y2 >= 2147462579) {
            y2 -= 2147462579;
        }
        this.x23 = this.x22;
        this.x22 = this.x21;
        this.x21 = y2;
        if (this.x11 <= this.x21) {
            return (double)(this.x11 - this.x21 + Integer.MAX_VALUE) * 4.656612873077393E-10;
        }
        return (double)(this.x11 - this.x21) * 4.656612873077393E-10;
    }
}

