\name{iClick.ARIMA}
\alias{iClick.ARIMA}
\title{
iClick GUI for ARIMA
}

\encoding{latin1}


\description{
This GUI estimates ARIMA both with automatic lag selection and fixed lag length. The GUI is only only a GUI, but also a output format.
}
\usage{
iClick.ARIMA(dat, AR = 1, MA = 1, n.ahead = 24, ic = "aic")
}

\arguments{
  \item{dat}{
Time series data frame, with the first column is the date string.
}
  \item{AR}{
Pre-specified fixed AR order.
}
  \item{MA}{
Pre-specified fixed MA order.
}
  \item{n.ahead}{
Periods of out-of-sample forecast.
}
  \item{ic}{
Information criteria for lag selection,ic=c("aicc", "aic", "bic"). See auto.arima() of package forecast. 
}
}
\details{
This GUI fits two ARMA, fixed orders and automatically fitted orders, and returns a two-part GUI with output on it. The outputs can be saved as .RData file for later use, the last row is the save button.\cr
The saved filename is automatically generated by selections and results; for example, .aicOrderARIMA_102.RData represents the automatically fits ARIMA(p,d,q) orders are ARIMA(1,0,2) by AIC.\cr Using load(".aicOrderARIMA_102.RData") to retrieve the file and ls() to list objects, and use names() to show details of objects.\cr
The input returns data must be in percentage form; namely, dlog()*100
}
\value{
Fitted ARMA regression output.
}

\author{
Ho Tsung-wu <tsungwu@mail.shu.edu.tw>
}

\seealso{
arima() and auto.arima() of package forecast.
}

\examples{

##== Unmark comments ## and execute
##data("returnsDaily24")
##dat=timeSeries::as.timeSeries(returnsDaily24) 
  # Creat a timeSeries object 
##y=dat[,5]  #Select the fifth variable

##iClick.ARIMA(y) 
#Default arguments can be changed easily.
#For example, 
##iClick.ARIMA(y,AR = 2, MA = 2, n.ahead = 12, #ic = "bic")

}

