% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F019.run.diffusion.map.R
\name{run.diffusion.map}
\alias{run.diffusion.map}
\title{Run diffusion map on PCA data (PHATE - Potential of Heat-Diffusion for Affinity-Based Transition Embedding)}
\usage{
run.diffusion.map(x = NULL, dims = 1:10, method = "phate",
  ndim = 3, k = 5, alpha = 40, n.landmark = 2000, gamma = 1,
  t = "auto", knn.dist.method = "euclidean", init = NULL,
  mds.method = "metric", mds.dist.method = "euclidean", t.max = 100,
  npca = 100, plot.optimal.t = FALSE, verbose = 1, n.jobs = 1,
  seed = NULL, potential.method = NULL, use.alpha = NULL,
  n.svd = NULL, pca.method = NULL, g.kernel = NULL, diff.op = NULL,
  landmark.transitions = NULL, diff.op.t = NULL, dist.method = NULL)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{dims}{PC dimentions to be used for UMAP analysis.}

\item{method}{diffusion map method, default = "phate".}

\item{ndim}{int, optional, default: 2 number of dimensions in which the data will be embedded}

\item{k}{int, optional, default: 5 number of nearest neighbors on which to build kernel}

\item{alpha}{int, optional, default: 40 sets decay rate of kernel tails. If NULL, alpha decaying kernel is not used}

\item{n.landmark}{int, optional, default: 2000 number of landmarks to use in fast PHATE}

\item{gamma}{float, optional, default: 1 Informational distance constant between -1 and 1. gamma=1 gives the PHATE log potential, gamma=0 gives a square root potential.}

\item{t}{int, optional, default: 'auto' power to which the diffusion operator is powered sets the level of diffusion}

\item{knn.dist.method}{string, optional, default: 'euclidean'. recommended values: 'euclidean', 'cosine', 'precomputed' Any metric from scipy.spatial.distance can be used distance metric for building kNN graph. If 'precomputed', data should be an n_samples x n_samples distance or affinity matrix. Distance matrices are assumed to have zeros down the diagonal, while affinity matrices are assumed to have non-zero values down the diagonal. This is detected automatically using data[0,0]. You can override this detection with knn.dist.method='precomputed_distance' or knn.dist.method='precomputed_affinity'.}

\item{init}{phate object, optional object to use for initialization. Avoids recomputing intermediate steps if parameters are the same.}

\item{mds.method}{string, optional, default: 'metric' choose from 'classic', 'metric', and 'nonmetric' which MDS algorithm is used for dimensionality reduction}

\item{mds.dist.method}{string, optional, default: 'euclidean' recommended values: 'euclidean' and 'cosine'}

\item{t.max}{int, optional, default: 100. Maximum value of t to test for automatic t selection.}

\item{npca}{int, optional, default: 100 Number of principal components to use for calculating neighborhoods. For extremely large datasets, using n_pca < 20 allows neighborhoods to be calculated in log(n_samples) time.}

\item{plot.optimal.t}{boolean, optional, if TRUE, produce a plot showing the Von Neumann Entropy curve for automatic t selection.}

\item{verbose}{int or boolean, optional (default : 1) If TRUE or > 0, message verbose updates.}

\item{n.jobs}{int, optional (default: 1) The number of jobs to use for the computation. If -1 all CPUs are used. If 1 is given, no parallel computing code is used at all, which is useful for debugging. For n_jobs below -1, (n.cpus + 1 + n.jobs) are used. Thus for n_jobs = -2, all CPUs but one are used}

\item{seed}{int or NULL, random state (default: NULL)}

\item{potential.method}{Deprecated. For log potential, use gamma=1. For sqrt potential, use gamma=0.}

\item{use.alpha}{Deprecated To disable alpha decay, use alpha=NULL}

\item{n.svd}{Deprecated.}

\item{pca.method}{Deprecated.}

\item{g.kernel}{Deprecated.}

\item{diff.op}{Deprecated.}

\item{landmark.transitions}{Deprecated.}

\item{diff.op.t}{Deprecated.}

\item{dist.method}{Deprecated.}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and runs diffusion map on PCA data.
}
