% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIARsample.R
\name{BIARsample}
\alias{BIARsample}
\title{Simulate from a BIAR Model}
\usage{
BIARsample(n, st, phiR, phiI, delta1 = 0, delta2 = 0, rho = 0)
}
\arguments{
\item{n}{Length of the output bivariate time series. A strictly positive integer.}

\item{st}{Array with observational times.}

\item{phiR}{Autocorrelation coefficient of BIAR model. A value between -1 and 1.}

\item{phiI}{Crosscorrelation coefficient of BIAR model. A value between -1 and 1.}

\item{delta1}{Array with the measurements error standard deviations of the first time series of the bivariate process.}

\item{delta2}{Array with the measurements error standard deviations of the second time series of the bivariate process.}

\item{rho}{Contemporary correlation coefficient of BIAR model. A value between -1 and 1.}
}
\value{
A list with the following components:
\itemize{
\item{y}{ Matrix with the simulated BIAR process.}
\item{t}{ Array with observation times.}
\item{Sigma}{ Covariance matrix of the process.}
}
}
\description{
Simulates a BIAR Time Series Model
}
\details{
The chosen phiR and phiI values must satisfy the condition $|phiR + i phiI| < 1$.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
x=BIARsample(n=n,phiR=0.9,phiI=0.3,st=st)
plot(st,x$y[1,],type='l')
plot(st,x$y[2,],type='l')
x=BIARsample(n=n,phiR=-0.9,phiI=-0.3,st=st)
plot(st,x$y[1,],type='l')
plot(st,x$y[2,],type='l')
}
\references{
\insertRef{Elorrieta_2021}{iAR}
}
\seealso{
\code{\link{gentime}}
}
