% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARt.R
\name{IARt}
\alias{IARt}
\title{Maximum Likelihood Estimation of the IAR-T model}
\usage{
IARt(y, st, nu = 3)
}
\arguments{
\item{y}{Array with the time series observations}

\item{st}{Array with the irregular observational times}

\item{nu}{degrees of freedom}
}
\value{
A list with the following components:
\itemize{
\item{phi}{ MLE of the phi parameter of the IAR-T model.}
\item{sigma}{ MLE of the sigma parameter of the IAR-T model.}
\item{ll}{ Value of the negative log likelihood evaluated in phi and sigma.}
}
}
\description{
Maximum Likelihood Estimation of the IAR-T model.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
y<-IARtsample(n,0.9,st,sigma2=1,nu=3)
model<-IARt(y$y, st=st)
phi=model$phi
sigmaest=model$sigma
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARtsample}}, \code{\link{IARphit}}
}
