% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/assemble.R
\name{assemble}
\alias{assemble}
\alias{assemble,i2dashboard-method}
\title{Generate an RMarkdown file from an \linkS4class{i2dashboard} object.}
\usage{
assemble(dashboard, ...)

\S4method{assemble}{i2dashboard}(
  dashboard,
  file,
  pages = names(dashboard@pages),
  exclude = NULL,
  render = FALSE,
  ...
)
}
\arguments{
\item{dashboard}{A \linkS4class{i2dashboard}.}

\item{...}{Additional arguments passed on to '\code{rmarkdown::render()}'.}

\item{file}{The path and filename of the resulting Rmd file (recommend that the suffix should be '.Rmd').}

\item{pages}{A string or vector with the names of pages, which should be assembled into the resulting Rmd file}

\item{exclude}{A string or vector with the names of pages, which should be excluded from dashboard assembly.}

\item{render}{A logical indicating whether the assembled dashboard should immediately be rendered with '\code{rmarkdown::render()}' or run with '\code{rmarkdown::run()}'.}
}
\value{
Invisibly returns the unmodified \linkS4class{i2dashboard} object.
}
\description{
Generate an RMarkdown file from an \linkS4class{i2dashboard} object.
}
\examples{
\donttest{
i2dashboard() \%>\% assemble(file="MyDashboard.Rmd")
i2dashboard() \%>\%
    add_page("p1", "Title 1") \%>\%
    add_page("p2", "Title 2") \%>\%
    assemble(file="MyDashboard.Rmd", exclude="default", render=TRUE)
}
}
