% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registerBand3.R
\name{registerBand3}
\alias{registerBand3}
\title{Single Band-to-Band Registration (Rotation and Translation)}
\usage{
registerBand3(slave, master, ncells = 24, orient = 8, start_affine)
}
\arguments{
\item{slave}{An object of class \code{RasterLayer} (from package
\link{raster}).}

\item{master}{An object of class \code{RasterLayer} (from package
\link{raster}).}

\item{ncells}{An integer giving the number of cells to compute the oriented
gradients of the HOG descriptor. Default is 24. See \code{\link[OpenImageR:HOG]{OpenImageR::HOG()}}.}

\item{orient}{An integer giving the number of orientations to compute the
oriented gradients of the HOG descriptor. Default is 8. See \code{\link[OpenImageR:HOG]{OpenImageR::HOG()}}.}

\item{start_affine}{A numeric vector containing the starting values for the
affine parameters to be optimized, i.e., the shift in x and y and the
rotation angle (in degrees). Example: \code{start_affine = c(1, 0, -2)},
which indicates a shift of 1 in the x-axis, 0 in the y-axis and a
clockwise (negative values) angle of 2 degrees. See more in \code{\link[=affineBrick]{affineBrick()}}.}
}
\value{
An object of the same classe as the input \code{slave}, with
the fixed extent. An additional attribute called \code{'affine_pars'} is
stored, containing the rotation angle (degrees) and the shift in x and y
in the same unit as the spatial extent of the image.
}
\description{
Hyperspectral image acquisition normaly causes spatial misalignment between
the spectral bands (layers) due to both equipment (such as band-to-band
recording delay) and external factors (e.g. sensor vibrations). In this case,
a geometric correction is necessary for remote sensing applications such
as combining/merging spectral bands. This function uses the HOG (Histogram
of Oriented Gradient) descriptor in order to find the optimal rotation
angle and translation (xy shift) on a 'slave' band to be spatially align
with a 'master' (reference) band.
}
\details{
This should be used carefully, as rotation affects the spatial
dimensions. It is recommended to try \code{\link[=registerBand]{registerBand()}} first.

The affine parameters are estimated using a general optimization algorithm.
}
\examples{
p <- system.file('exdata', 'soybean.tif', package = 'hyperbrick')
im <- brick(p)
print(im)

# see how layer 1 is misregistered
plot(im[[3]], col = gray.colors(20), asp = 0)
plot(im[[1]], add = TRUE, legend = FALSE,
     col = adjustcolor(terrain.colors(20), 0.6))

# remove the #s to run
# b1_reg <- registerBand3(slave = im[[1]], master = im[[3]],
#                         start_affine = c(0, 0, -2.5))
# attr(b1_reg, "affine_pars")

# plot(im[[3]], col = gray.colors(20), asp = 0)
# plot(b1_reg, add = TRUE, legend = FALSE,
#      col = adjustcolor(terrain.colors(20), 0.6))


}
\seealso{
\code{\link[OpenImageR:HOG]{OpenImageR::HOG()}}, \code{\link[=registerBrick]{registerBrick()}}, \code{\link[=registerBand]{registerBand()}}
}
