% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\docType{methods}
\name{as.hyperSpec}
\alias{as.hyperSpec}
\alias{as.hyperSpec,matrix-method}
\alias{as.hyperSpec,data.frame-method}
\title{as.hyperSpec: convenience conversion functions}
\usage{
as.hyperSpec(X, ...)

\S4method{as.hyperSpec}{matrix}(X, wl = guess.wavelength(colnames(X)), ...)

\S4method{as.hyperSpec}{data.frame}(X, wl = guess.wavelength(colnames(X)),
  ...)
}
\arguments{
\item{X}{the object to convert}

\item{...}{additional parameters that should be handed over to \code{new ("hyperSpec")} (initialize)}

\item{wl}{wavelength vector. Defaults to guessing from the column names in \code{X}}
}
\value{
hyperSpec object
}
\description{
These functions are shortcuts to convert other objects into hypeSpec objects.
}
\examples{
tmp <- data.frame(flu [[,, 400 ~ 410]])
(wl <- colnames (tmp))
guess.wavelength (wl)
}
\seealso{
\code{\link[hyperSpec]{initialize}}
}
