% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/read.jdx.R, R/read.jdx.Shimadzu.R
\name{read.jdx}
\alias{read.jdx}
\alias{read.jdx.Shimadzu}
\title{JCAMP-DX Import for Shimadzu Library Spectra}
\usage{
read.jdx(filename = stop("filename is needed"), encoding = "",
  header = list(), keys.hdr2data = FALSE, ..., NA.symbols = c("NA", "N/A",
  "N.A."), collapse.multi = TRUE)

read.jdx.Shimadzu(...)
}
\arguments{
\item{filename}{file name and path of the .jdx file}

\item{encoding}{encoding of the JCAMP-DX file (used by \code{\link[base]{readLines}})}

\item{header}{list with manually set header values}

\item{keys.hdr2data}{index vector indicating which header entries should be tranfered into the
extra data. Usually a character vector of labels (lowercase, without and dashes, blanks,
underscores). If \code{TRUE}, all header entries are read.}

\item{...}{further parameters handed to the data import function, e.g.
\tabular{ll}{
\code{xtol} \tab tolerance for checking calculated x values against checkpoints at beginning
                 of line, defaults to XFACTOR\cr
\code{ytol} \tab tolerance for checking Y values against MINY and MAXY, defaults to YFACTOR\cr
}}

\item{NA.symbols}{character vector of text values that should be converted to \code{NA}}

\item{collapse.multi}{should hyperSpec objects from multispectra files be collapsed into one
hyperSpec object (if \code{FALSE}, a list of hyperSpec objects is returned).}
}
\value{
hyperSpec object
}
\description{
this is a first rough import function for JCAMP-DX spectra.
}
\details{
So far, AFFN and PAC formats are supported for simple XYDATA, DATA TABLEs and PEAK TABLEs.

NTUPLES / PAGES are not (yet) supported.

DIF, DUF, DIFDUP and SQZ data formats are not (yet) supported.
}
\note{
JCAMP-DX support is incomplete and the functions may change without notice. See
\code{vignette ("fileio")}  and the details section.

\code{read.jdx.Shimadzu}  is now defunct. Please use \code{read.jdx} instead.
}
\author{
C. Beleites with contributions by Bryan Hanson
}

