\name{PlotResults}

\alias{PlotResults}

\title{
Plotting the results of optimisation/calibration or verification
}
\description{
It takes the optimisation/calibration or verifcation results of a model and then produces the following plots \bold{(*)}: \cr

 1) ModelOut_BCS_from_Pareto_Optimal_Front_vs_Obs: Graphic comparison of time series of observed and simulated variables (taking the simulation of the best compromise solution) \cr
 2) ModelOut_from_Pareto_Optimal_Front: Uncertainty band that encompasses the simulations given by all the solutions of the Pareto Optimal Front, in a time series. The time series of the best compromise solution is distinguished \cr
 3) ModelOut_from_Pareto_Optimal_Front_vs_Obs: Graphic comparison of time series of observed and simulated variables (taking an uncertainty band that encompasses the simulations given by all solutions of the Pareto Optimal Front) \cr
 4) Parameters_on_Pareto_Optimal_Front_Dottyplots: Dottyplots that compare parameter values of the solutions of the Pareto Optimal Front vs. the values of the objectives \bold{(**)} \cr
 6) Parameters_on_Pareto_Optimal_Front: Boxplot of parameter values (Pareto Optimal Front solutions) \cr
 7) Solutions_2D_Compromise:  \cr

\bold{(*)}: When \code{do.png == TRUE}, graphics are written to disk \cr
\bold{(**)}: As many graphs are generated as targets specified in the optimisation \cr

}
\usage{

PlotResults(Results,
            do.png = FALSE,
            main = "study case #1",
            drty.out = "MOPSO.out")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Results}{(\code{list}) \cr
List with \code{hydroMOPSO} optimisation results or \code{hydroVerification} results. The details of this input are explained in the value returned by \code{hydroMOPSO} and \code{hydroVerification} function
}
  \item{do.png}{(\code{logical}) \cr
Indicates whether the graphics will be written to disk (in png format) or not \cr
By default, graphics are not written \code{do.png = FALSE}
}
  \item{main}{(\code{character}) \cr
Title for the plots, usually an identifiable name of the case study
}
  \item{drty.out}{(\code{character}) \cr
Path to the directory storing the output files generated by hydroMOPSO
}
}
%%\details{
%%  ~~ If necessary, more details than the description above ~~
%%}

\value{
No return value
}


%%\references{
%% ~put references to the literature/web site here ~
%%}
\author{
Rodrigo Marinao Rivas \email{ra.marinao.rivas@gmail.com}, Mauricio Zambrano-Bigiarini, \email{mzb.devel@gmail.com}
}

%%\note{

%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{hydroMOPSO}
}
%%\examples{
%%}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{multi-objective optimisation}
\keyword{verification}
\keyword{hydrological model}