% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequent_depth.R
\name{sequent_depth}
\alias{sequent_depth}
\title{Solves the Momentum Equation for sequent (or conjugate) depth in a trapezoidal channel}
\usage{
sequent_depth(
  Q = NULL,
  b = NULL,
  y = NULL,
  m = NULL,
  units = c("SI", "Eng"),
  ret_units = FALSE
)
}
\arguments{
\item{Q}{numeric vector that contains the flow rate [\eqn{m^3 s^{-1}}{m^3/s} or \eqn{ft^3 s^{-1}}{ft^3/s}]}

\item{b}{numeric vector that contains the channel bottom width [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{y}{numeric vector that contains the water depth [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{m}{numeric vector that contains the side slope of the channel (m:1 H:V) [unitless]}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units. This is used for compatibility with iemisc package.}

\item{ret_units}{If set to TRUE the value(s) returned are of class \code{units} with
units attached to the value. [Default is FALSE]}
}
\value{
Returns a list including:
\itemize{
  \item y - input depth
  \item y_seq - sequent depth
  \item yc - critical depth
  \item Fr - Froude number for input depth
  \item Fr_seq - Froude number for sequent depth
  \item E - specific energy for input depth
  \item E_seq - specific energy for sequent depth
}
}
\description{
This function solves the Momentum equation for water flow in an open 
channel with a trapezoidal shape and determines the sequent (conjugate) depth.
This is the flow depth either upstream or downstream of a hydraulic jump, 
whichever is not provided as input.
}
\details{
The Momentum equation for open channel flow conditions in a trapezoidal channel: 
\deqn{M = \frac{by^2}{2}+\frac{my^3}{3}+\frac{Q^2}{gy\left(b+my\right)}}
where \eqn{C}{C} is 1.0 for SI units and 1.49 for Eng (U.S. Customary) units. 
The momentum function is assumed to be the same on both sides of a hydraulic
jump, allowing the determination of the sequent depth.
}
\examples{

#Solving for sequent depth: SI Units
#Flow of 0.2 m^3/s, bottom width = 0.5 m, Depth = 0.1 m, side slope = 1:1
sequent_depth(Q=0.2,b=0.5,y=0.1,m=1,units = "SI", ret_units = TRUE)

}
\author{
Ed Maurer
}
