% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_colebrook.R
\name{colebrook_f}
\alias{colebrook_f}
\alias{velocity}
\alias{reynolds_number}
\alias{colebrook}
\title{Calculates the Darcy-Weisbach Friction Factor f}
\usage{
velocity(D = NULL, Q = NULL)

reynolds_number(V = NULL, D = NULL, nu = NULL)

colebrook(ks, V, D, nu)
}
\arguments{
\item{D}{numeric vector that contains the pipe diameter [m or ft]
which should be D >=0.0025 m (0.0082 ft).}

\item{Q}{(for velocity function only) numeric vector that contains the flow rate
[m^3/s or ft^3/s]}

\item{V}{numeric vector that contains the average Velocity of flow in the pipe,
equal to flow divided by area, Q/A [m/s or ft/s]}

\item{nu}{numeric vector that contains the kinematic viscosity of water,
[m2 s-1 or ft2 s-1]. Computed with a utility function in water_properties.R:
kvisc(T=T, units=['SI' or 'Eng'])}

\item{ks}{numeric vector that contains the 'equivalent sand roughness height
sand roughness height. Units should be consistent with other input [m or ft]}
}
\value{
f Returns a numeric vector containing the Darcy-Weisbach friction
  factor
}
\description{
This function calculates the Darcy-Weisbach friction factor
and is only provided in this package for use with water in circular pipes
while the equation is technically valid for any liquid.
As with many parts of this package, techniques and formatting
were drawn from Irucka Embry's iemisc package, which includes some
methods with similar functionality.
}
\examples{

# A Type 1 problem (solve for hf): US units
D <- 20/12   #diameter of 20 inches
Q <- 4       #flow in ft^3/s
T <- 60      #water temperature in F
ks <- 0.0005 #pipe roughness in ft

f <- colebrook(ks=ks,V=velocity(D,Q), D=D, nu=kvisc(T=T, units="Eng"))

}
\seealso{
\code{\link{kvisc}} for kinematic viscosity, \code{\link{velocity}} for
calculating V=Q/A, \code{\link{reynolds_number}} for Reynolds number
}
\author{
Ed Maurer
}
