% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterLevelFlys3InterpolateX.R
\name{waterLevelFlys3InterpolateX}
\alias{waterLevelFlys3InterpolateX}
\title{Interpolate FLYS3 water levels for given stations}
\usage{
waterLevelFlys3InterpolateX(
  river = c("Elbe", "Rhine"),
  station = NULL,
  station_int = NULL
)
}
\arguments{
\item{river}{a required argument to fill the \linkS4class{WaterLevelDataFrame}-slot
\code{river}. It has to be type \code{character}, has to have a length of
one and can be either \strong{Elbe} or \strong{Rhine}.}

\item{station}{an optional argument to hand over the stationing along the
specified \code{river}. If specified, it has to be type \code{numeric}
and has to have the same length as other optional arguments (\code{id},
\code{station_int} and \code{w}) forming the \code{\link[base]{data.frame}}-component
of a \linkS4class{WaterLevelDataFrame}. If both stationing arguments
(\code{station} and \code{station_int}) are specified, all elements of
\code{station} have to be equal to
\code{\link[base:numeric]{as.numeric}(station_int / 1000)}.
Minimum and maximum allowed values of \code{station} are
\code{river}-specific: Elbe (km 0 - 585.7), Rhine (km 336.2 - 865.7).}

\item{station_int}{an optional argument to hand over the stationing along the
specified \code{river}. If specified, it has to be type \code{integer}
and has to have the same length as other optional arguments (\code{id},
\code{station} and \code{w}) forming the \code{\link[base]{data.frame}}-component of a
\linkS4class{WaterLevelDataFrame}. If both stationing arguments (\code{station}
and \code{station_int}) are specified, all elements of \code{station_int}
have to be equal to \code{\link[base:integer]{as.integer}(station * 1000)}.
Minimum and maximum allowed values of \code{station_int} are \code{river}-specific:
Elbe (m 0 - 585700), Rhine (m 336200 - 865700).}
}
\value{
An object of class \code{\link[base]{data.frame}} with the structure of
  \code{\link{df.flys}}.
}
\description{
Function to interpolate
  \href{https://www.bafg.de/DE/5_Informiert/1_Portale_Dienste/FLYS/flys_node.html}{FLYS3}
  water levels for selected stations and return it with the structure of
  \code{\link{df.flys}}.
}
\details{
\code{\link{df.flys}} contains 1d water level data computed
  with SOBEK for every second hectometer (every 200 m). This function
  provides a way to interpolate the 30 stationary water levels for selected
  stations inbetween these hectometers and returns them with the 
  \code{\link[base]{data.frame}}-structure of the original dataset.
}
\examples{
df.flys  <- waterLevelFlys3InterpolateX("Elbe", 257.1)

}
\references{
\insertRef{busch_einheitliche_2009}{hyd1d}
  
  \insertRef{hkv_hydrokontor_erstellung_2014}{hyd1d}
  
  \insertRef{deltares_sobek_2018}{hyd1d}
}
\seealso{
\code{\link{df.flys}}
}
