% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{hweboot}
\alias{hweboot}
\title{Bootstrap procedure to test for equilibrium}
\usage{
hweboot(n, nboot = 2000, more = FALSE)
}
\arguments{
\item{n}{One of two forms
\describe{
\item{A vector of length ploidy + 1}{Element i is the number of
individuals with genotype i.}
\item{A matrix with nsamp rows and ploidy+1 columns}{Element (i, j)
is the posterior probability that individual i has ploidy j-1.}
}}

\item{nboot}{The number of bootstrap samples to run.}

\item{more}{A logical. Should we return the bootstrap replicates
(\code{FALSE}) or just the p-value, with 95\% confidence interval
of the p-value (\code{TRUE}).}
}
\value{
A list with some or all of the following elements
\describe{
\item{\code{p_hwe}}{The bootstrap p-value against the null of equilibrium.}
\item{\code{p_ci}}{The 95\% confidence interval of p_hwe.}
\item{\code{alpha_boot}}{The bootstrap samples of the double reduction
parameter.}
\item{\code{u_boot}}{The bootstrap samples of the U-statistic.}
}
}
\description{
Iteratively resample individuals/genotypes, calculating the U-statistic
for each resample, and use these resamples to test against the null
of no equilibrium.
}
\examples{
set.seed(1)
ploidy <- 6
size <- 100
r <- 0.5
alpha <- 0.1
qvec <- hwefreq(r = r, alpha = alpha, ploidy = ploidy)
nvec <- c(rmultinom(n = 1, size = size, prob = qvec))
bout <- hweboot(n = nvec, more = TRUE, nboot = 1000)
bout$p_hwe
bout$p_ci
hist(bout$test_boot)
abline(v = bout$test_stat, lty = 2, col = 2)

}
\author{
David Gerard
}
