% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seg.R
\name{dgamete}
\alias{dgamete}
\title{Gamete dosage probability}
\usage{
dgamete(x, alpha, G, ploidy, log_p = FALSE)
}
\arguments{
\item{x}{A vector of numerics in \code{seq(0, ploidy/2)}. The dosage of the
gametes.}

\item{alpha}{A numeric vector containing the double reduction parameter(s).
This should be a
vector of length \code{floor(ploidy/4)} where \code{alpha[i]}
is the probability of exactly \code{i} pairs of IBDR alleles
being in the gamete. Note that \code{sum(alpha)} should be less than
1, as \code{1 - sum(alpha)} is the probability of no double reduction.}

\item{G}{The dosage of the parent. Should be an integer between \code{0}
and \code{ploidy}.}

\item{ploidy}{The ploidy of the species. This should be an even positive
integer.}

\item{log_p}{A logical. Should we return the log-probability (\code{TRUE})
or not (\code{FALSE})? Defaults to \code{FALSE}.}
}
\value{
A vector of length \code{length(x)}, containing the (log)
probabilities of a gamete carrying a dosage of \code{x} from a
parent of dosage \code{G} who has ploidy \code{ploidy} and a
double reduction rate \code{alpha}.
}
\description{
Estimates the probability of a gamete dosage given the parent dosage
(\code{G}), the parent ploidy (\code{ploidy}), and the double reduction
parameter (\code{alpha}). This is for biallelic loci.
}
\examples{
dgamete(x = 0:2, alpha = 0, G = 2, ploidy = 4)

}
\author{
David Gerard
}
