% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping-functions.R
\name{by_values}
\alias{by_values}
\title{Map specific cell values to cell properties}
\usage{
by_values(..., ignore_na = TRUE)
}
\arguments{
\item{...}{Name-value pairs like \code{name = value}. Cells where contents are equal to
\code{name} will have the property set to \code{value}. If there is a single unnamed argument,
this is the default value for unmatched cells. More than one unnamed argument is an error.}

\item{ignore_na}{If \code{TRUE}, \code{NA} values in the result will be left unchanged
from their previous values. Otherwise, \code{NA}
normally resets to the default.}
}
\value{
A function for use in \verb{map_***} functions.
}
\description{
Map specific cell values to cell properties
}
\examples{
ht <- hux(letters[1:3])
map_background_color(ht,
      by_values(a = "red", c = "yellow"))
map_background_color(ht,
      by_values(a = "red", c = "yellow", "green"))
}
\seealso{
\link{mapping-functions}

Other mapping functions: 
\code{\link{by_cases}()},
\code{\link{by_colorspace}()},
\code{\link{by_function}()},
\code{\link{by_quantiles}()},
\code{\link{by_ranges}()},
\code{\link{by_regex}()},
\code{\link{by_rows}()}
}
\concept{mapping functions}
