% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulation.R
\name{[.huxtable}
\alias{[.huxtable}
\alias{[<-.huxtable}
\alias{$<-.huxtable}
\alias{[[<-.huxtable}
\title{Subset a huxtable}
\usage{
\method{[}{huxtable}(x, i, j, drop = FALSE)

\method{[}{huxtable}(x, i, j) <- value

\method{$}{huxtable}(x, name) <- value

\method{[[}{huxtable}(x, i, j) <- value
}
\arguments{
\item{x}{A huxtable.}

\item{i}{Rows to select.}

\item{j, name}{Columns to select.}

\item{drop}{Not used.}

\item{value}{A matrix, data frame, huxtable or similar object.}
}
\value{
A huxtable.
}
\description{
Subset a huxtable
}
\details{
\code{[} always returns a huxtable, while \code{$} and \code{[[}
return the underlying data.

For the replacement function \code{[<-}, if \code{value} is a huxtable, then its cell properties will be
copied into \code{x}. In addition, if \code{value} fills up an entire column, then column properties
will be copied into the replaced columns of \code{x}, and if it fills up an entire row, then
row properties will be copied into the replaced rows of \code{x}.

Replacement functions \code{$<-} and \code{[[<-} replace existing data without affecting any properties.
}
\examples{
jams[1:3, ]
class(jams[1:3, ])
jams[, 1]
jams$Type
prices <- huxtable(c("Price", 1.70, 2.00, 2.20))
number_format(prices) <- 2
bold(prices) <- TRUE
jams[, 2] <- prices
jams

data(jams)
jams$price <- c("Price", 1.70, 2.00, 2.20)
jams
}
