% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{na_string}
\alias{na_string}
\alias{na_string<-}
\alias{set_na_string}
\alias{map_na_string}
\title{NA string}
\usage{
na_string(ht)
na_string(ht) <- value
set_na_string(ht, row, col, value, byrow = FALSE)
map_na_string(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character string. This will be used to replace NA values in the display.

Set to \code{NA} to reset to the default, which is \code{""}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{na_string}, the \code{na_string} property.
For \code{set_na_string} and \code{map_na_string}, the modified huxtable.
}
\description{
Functions to get or set the \emph{na string} property of huxtable cells.
}
\examples{

na_string(jams) <-  "--"
na_string(jams)
jams[2,2] <- NA 
jams

jams2 <- set_na_string(jams,
      "--")
na_string(jams2)

jams3 <- set_na_string(jams,
      2:3, 1, "--")
na_string(jams3)

jams4 <- map_na_string(jams,
      by_rows(
        "--",
        "")
      )
na_string(jams4)
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font_size}},
  \code{\link{font}}, \code{\link{number_format}},
  \code{\link{text_color}}
}
\concept{formatting functions}
