% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{left_border}
\alias{left_border}
\alias{left_border<-}
\alias{set_left_border}
\alias{right_border}
\alias{top_border}
\alias{bottom_border}
\alias{right_border<-}
\alias{top_border<-}
\alias{bottom_border<-}
\alias{set_right_border}
\alias{set_top_border}
\alias{set_bottom_border}
\title{Borders}
\usage{
left_border(ht)
left_border(ht) <- value
set_left_border(ht, row, col, value, byrow = FALSE)

right_border(ht)
right_border(ht) <- value
set_right_border(ht, row, col, value, byrow = FALSE)

top_border(ht)
top_border(ht) <- value
set_top_border(ht, row, col, value, byrow = FALSE)

bottom_border(ht)
bottom_border(ht) <- value
set_bottom_border(ht, row, col, value, byrow = FALSE)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric vector or matrix giving border widths in points. Set to 0 for no border. Set to \code{NA} to reset to the default, which is
\code{0}.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details.}

\item{col}{An optional column specifier.}

\item{byrow}{If \code{TRUE}, fill in values by row rather than by column.}
}
\value{
For \code{left_border}, the \code{left_border} property.
For \code{set_left_border}, the \code{ht} object.

Similarly for the other functions.
}
\description{
Functions to get or set the \emph{borders} property of huxtable cells.
}
\details{
Currently in LaTeX, all non-zero border widths on a given line must be the same, and vertical border widths
can only be present (if \code{value > 0}) or absent.
}
\section{Note}{

huxtable currently sets borders on specific cells. This can lead to surprising behaviour when
cells span multiple rows or columns: see the example. This behaviour may be improved in a future
release.
}

\examples{

ht <- huxtable(a = 1:3, b = 1:3)
left_border(ht) <-  1
left_border(ht)
print_screen(ht)

ht <- huxtable(a = 1:3, b = 3:1)
set_left_border(ht, 1)
set_left_border(ht, 1:2, 1, 1)
set_left_border(ht, 1:2, 1:2, c(1, 2), byrow = TRUE)
set_left_border(ht, where(ht == 1), 1)
# When cells span multiple rows:
ht <- tribble_hux(
  ~Col1,                   ~Col2,
  "Cell 1,1 spans 2 rows", "Cell 1,2",
  "Cell 2,1 is invisible", "Cell 2,2"
)
rowspan(ht)[1, 1] <- 2
ht
bottom_border(ht)[2, ] <- 1
bottom_border_color(ht)[2, ] <- 'red'
# Cell 1, 1 does not have a border set:
ht
# Fixed:
bottom_border(ht)[1, 1] <- 1
bottom_border_color(ht)[1, 1] <- 'red'
ht
}
\seealso{
\code{\link[=set_all_borders]{set_all_borders()}}
}
