% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{knit_print.data.frame}
\alias{knit_print.data.frame}
\title{Print data frames in knitr using huxtable}
\usage{
knit_print.data.frame(x, options, ...)
}
\arguments{
\item{x}{A huxtable.}

\item{options}{Not used.}

\item{...}{Not used.}
}
\description{
Print data frames in knitr using huxtable
}
\details{
\code{huxtable} defines a \code{knit_print} method for \code{data.frame}s. This converts the data frame
to a huxtable, with \code{add_colnames = TRUE}, themes it using \code{\link[=theme_plain]{theme_plain()}} and prints it.
It also tries to set a few intelligent defaults, e.g. wrapping long columns and setting
an appropriate width.
To turn this behaviour off, set \code{options(huxtable.knit_print_df = FALSE)}. To change the theme, set
\code{options("huxtable.knit_print_df_theme")} to a one-argument function which should return the huxtable.
}
\examples{
\dontrun{
# in your knitr document
mytheme <- function (ht) {
  ht <- set_all_borders(ht, 0.4)
  ht <- set_all_border_colors(ht, "darkgreen")
  ht <- set_background_color(ht, evens, odds, "salmon")
  ht
}

options(huxtable.knit_print_df_theme = mytheme)
data.frame(a = 1:5, b = 1:5) # groovy!
}
}
\seealso{
\link{huxtable-options}

Other knit_print: \code{\link{knit_print.huxtable}}
}
\concept{knit_print}
