% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmatchp.R
\name{fmatchp}
\alias{fmatchp}
\alias{finp}
\alias{fnotinp}
\title{Parallel fastmatching}
\usage{
fmatchp(
  x,
  table,
  nomatch = NA_integer_,
  nThread = getOption("hutilscpp.nThread", 1L),
  fin = FALSE,
  whichFirst = 0L
)

finp(x, table, nThread = getOption("hutilscpp.nThread", 1L))

fnotinp(x, table, nThread = getOption("hutilscpp.nThread", 1L))
}
\arguments{
\item{x, table, nomatch}{As in \code{match}.}

\item{nThread}{Number of threads to use.}

\item{fin}{\code{TRUE | FALSE} Behaviour of return value when value found in
\code{table}. If \code{FALSE}, return the index of \code{table};
if \code{TRUE}, return \code{TRUE}.}

\item{whichFirst}{\code{integer(1)} If \code{0L}, not used. If positive,
returns the index of the first element in \code{x} found in \code{table};
if negative, returns the last element in \code{x} found in \code{table}.}
}
\description{
\code{fastmatch::fmatch} and logical versions, with parallelization.
}
\examples{
x <- c(1L, 4:5)
y <- c(2L, 4:5)
fmatchp(x, y)
fmatchp(x, y, nomatch = 0L)
finp(x, y)

}
