% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ein.R
\name{\%ein\%}
\alias{\%ein\%}
\alias{\%enotin\%}
\title{Exists and (not) in}
\usage{
x \%ein\% y

x \%enotin\% y
}
\arguments{
\item{x}{Values to be matched}

\item{y}{Values to be matched against.}
}
\value{
Same as \code{\%in\%} and \code{\%notin\%}, unless an element of \code{y} is not present in \code{x}.
}
\description{
A common blunder in R programming is to mistype one of a set of filters without realizing. 
This function will error if any member of the values to be matched against is not present.
}
\examples{
# Incorrectly assumed to include two Species
iris[iris$Species \%in\% c("setosa", "versicolour"), ]
\dontrun{
# Error:
iris[iris$Species \%ein\% c("setosa", "versicolour"), ]
}
}
