% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_cols_first.R
\name{set_cols_first}
\alias{set_cols_first}
\alias{set_cols_last}
\title{Put columns first or last}
\usage{
set_cols_first(DT, cols, intersection = TRUE)

set_cols_last(DT, cols, intersection = TRUE)
}
\arguments{
\item{DT}{A data.table.}

\item{cols}{Character vector of columns to put before (after) all others.}

\item{intersection}{Use the intersection of the names of \code{DT} and \code{cols}. If \code{FALSE} 
any \code{cols} are not the names of \code{DT}, the function may error on behalf of \code{data.table}.}
}
\description{
Reorder columns of a \code{data.table} (via \code{setcolorder}) so that particular columns 
appear first (or last).
}
\examples{
if (requireNamespace("data.table", quietly = TRUE)) {
  library(data.table)
  
  DT <- data.table(y = 1:5, z = 11:15, x = letters[1:5])
  set_cols_first(DT, "x")
}
}
