% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humidity.R
\name{RH}
\alias{RH}
\title{calculate relative humidity}
\usage{
RH(t, Td, isK = TRUE)
}
\arguments{
\item{t}{temperature in Kelvin (K) or in degree Celsius (°C)}

\item{Td}{dew point in Kelvin (K) or in degree Celsius (°C)}

\item{isK}{logical indicator whether temperature is in Kelvin (K). The default value is TRUE.}
}
\value{
numeric relative humidity in %.
}
\description{
calculate relative humidity \eqn{\psi} based on temperature \eqn{t} and dew point \eqn{T_d}
}
\examples{
RH(30, 15, isK = FALSE)
}
\seealso{
\code{\link{AH}}, \code{\link{SH}}.
}
\author{
Jun Cai (\email{cai-j12@mails.tsinghua.edu.cn}), PhD candidate from
Department of Earth System Science, Tsinghua University
}
