% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray_datasets.R
\docType{data}
\name{iChipRegionsB36}
\alias{iChipRegionsB36}
\title{Autoimmune enriched regions as mapped on ImmunoChip}
\format{An object of class GRanges}
\description{
Dataset. A consortium of 12 autoimmune diseases (Type 1 diabetes, Celiac
disease, Multiple Sclerosis, Crohns Disease, Primary Billiary Cirrhosis, 
Psoriasis, Rheumatoid Arthritis, Systemic Lupus Erytematosus, 
Ulcerative Colitis, Ankylosing Spondylitis, Autoimmune Thyroid Disease,
Juvenile Idiopathic Arthritis) created the ImmunoChip custom Illumina
iSelect microarray in order to investigate known regions from GWAS
associating with a p value < 5*10-8 with any of these diseases, using
dense mapping of locii. This object specifies the boundaries of these
regions, defined roughly as 0.1 centimorgan recombination distance either 
side of the top marker in each. The data is in the original build 36
coordinates as a GRanges object, but using functions in the humarray
package can easily be converted to build 37, 38 or RangedData/data.frame.
}
\examples{
data(iChipRegionsB36)
prv(iChipRegionsB36)
\donttest{iChipRegionsB37 <- conv.36.37(iChipRegionsB36) }
}
\references{
Cortes and Brown, Promise and pitfalls of the Immunochip (2011).
 Arthritis Research and Therapy 2011, 13:101
}
\seealso{
\code{\link{conv.36.37}} \code{\link{get.t1d.subset}}
 \code{\link{get.t1d.regions}} \code{\link{get.immunobase.snps}}
}
\keyword{datasets}
