% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_print.R
\name{label_print}
\alias{label_print}
\title{Label print}
\usage{
label_print(
  label,
  mode = "sample",
  filename = "labels",
  margin = 0.04,
  paper = c(21, 29.7),
  units = "cm",
  viewer = FALSE,
  smpres = 200,
  nlabels = NA
)
}
\arguments{
\item{label}{Data frame to build the labels or n repeated labels (table/numeric)}

\item{mode}{Label generation (string: "sample/preview", "complete")}

\item{filename}{Labels file name (string: "labels")}

\item{margin}{Labels margins. margin(numeric vector: t = 0, r = 0, b = 0, l = 0)}

\item{paper}{Paper size. Default A4 (numeric vector: 21.0 x 29.7)}

\item{units}{Units for the label options (string: "cm")}

\item{viewer}{Visualization of the label (logial: FALSE)}

\item{smpres}{Sample resolution if viewer = TRUE (numeric: 200)}

\item{nlabels}{Number of labels to generate (numeric: NA)}
}
\value{
pdf
}
\description{
Generate labels based in a data frame
}
\examples{

library(huito)

fb <- fieldbook

label <- fb \%>\% 
label_layout(size = c(10, 2.5)
             , border_color = "blue"
             ) \%>\%
  include_image(
    value = "https://flavjack.github.io/inti/img/inkaverse.png"
    , size = c(2.4, 2.4)
    , position = c(1.2, 1.25)
    ) \%>\%
  include_barcode(
    value = "barcode"
    , size = c(2.5, 2.5)
    , position = c(8.2, 1.25)
    ) \%>\%
  include_text(value = "plots"
               , position = c(9.7, 1.25)
               , angle = 90
               , size = 15
               , color = "red"
               ) \%>\%
  include_text(value = "Inkaverse"
               , position = c(4.6, 2)
               , size = 30
               , color = "brown"
               ) \%>\%
  include_text(value = "condition"
               , position = c(4.6, 1.2)
               , size = 13
               , color = "orange"
               ) \%>\%
  include_text(value = "genotypes"
               , position = c(4.6, 0.5)
               , size = 13
               , color = "#009966"
               ) \%>\% 
               label_print(mode = "sample")
  
}
