% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-function.R
\name{write_stream}
\alias{write_stream}
\title{Process output in a streaming manner.}
\usage{
write_stream(f)
}
\arguments{
\item{f}{Callback function. It should have a single argument, a raw
vector containing the bytes recieved from the server. This will usually
be 16k or less. The return value of the function is ignored.}
}
\description{
This is the most general way of processing the response from the server -
you receive the raw bytes as they come in, and you can do whatever you want
with them.
}
\examples{
GET("https://jeroenooms.github.io/data/diamonds.json",
  write_stream(function(x) {
   print(length(x))
   length(x)
 })
)
}

