% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public.R
\name{public}
\alias{public}
\title{Test that functions are exported}
\usage{
public(...)
}
\arguments{
\item{...}{Code to evaluate}
}
\value{
The result of \code{...} evaluated in the global environment (and not
the package environment).
}
\description{
It's easy to forget to document and export a new function. Using \code{testthat}
for your test suite makes it even easier to forget because it evaluates your
test code inside the package's namespace, so internal, non-exported functions
can be accessed. So you might write a new function, get passing tests, and
then tell your package users about the function, but when they try to run it,
they get \verb{Error: object 'coolNewFunction' not found}.
}
\details{
Wrap \code{public()} around test blocks to assert that the functions they call
are exported (and thus fail if you haven't documented them with \verb{@export}
or otherwise added them to your package NAMESPACE file).

An alternative way to test that your functions are exported from the package
namespace is with examples in the documentation, which \verb{R CMD check} runs
in the global namespace and would thus fail if the functions aren't exported.
However, code that calls remote APIs, potentially requiring specific server
state and authentication, may not be viable to run in examples in
\verb{R CMD check}. \code{public()} provides a solution that works for these cases
because you can test your namespace exports in the same place where you are
testing the code with API mocks or other safe testing contexts.
}
