% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{uncached}
\alias{uncached}
\title{Context manager to temporarily turn cache off if it is on}
\usage{
uncached(...)
}
\arguments{
\item{...}{Things to evaluate with caching off}
}
\value{
Whatever ... returns.
}
\description{
If you don't want to store the response of a GET request in the cache,
wrap it in \code{uncached()}. Note that if the response is already found
in the cache, as from a previous request that was not uncached, you will
get the cached response. That is, this function prevents writing to cache,
but it does not prevent reading from cache.
}
\examples{
uncached(GET("http://httpbin.org/get"))
}

